package gov.va.vinci.dart.json.builder;

import java.text.SimpleDateFormat;

import gov.va.vinci.dart.biz.RequestLocationDocumentSummary;
import gov.va.vinci.dart.biz.RequestParticipantDocumentSummary;
import gov.va.vinci.dart.json.DocumentVersionView;

public class DocumentVersionViewBuilder {
	public static final SimpleDateFormat LONG_FORMAT_SDF = new SimpleDateFormat("MM/dd/yy hh:mmaa");

	public DocumentVersionView build(final RequestLocationDocumentSummary summary) {
		DocumentVersionView result = new DocumentVersionView();
		
		result.setId(summary.getDocumentId());
		result.setName(summary.getDocumentName());
		result.setUpdatedBy(summary.getUpdatedBy());
		result.setUpdatedOn(LONG_FORMAT_SDF.format(summary.getUpdatedOn()));
		result.setVersionNumber(summary.getVersionNumber());
		
		return result;
	}
	
	public DocumentVersionView build(final RequestParticipantDocumentSummary summary) {
		DocumentVersionView result = new DocumentVersionView();
		
		result.setId(summary.getDocumentId());
		result.setName(summary.getDocumentName());
		result.setUpdatedBy(summary.getUpdatedBy());
		result.setUpdatedOn(LONG_FORMAT_SDF.format(summary.getUpdatedOn()));
		result.setVersionNumber(summary.getVersionNumber());
		
		return result;
	}

}
